set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 4.

*1. Prepare data: construct annualized long differences in laborshare & log laborshare by country within each decade
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	replace laborshare=laborshare/100
	keep country code cross year VA LAB laborshare
	gen lnlaborshare=ln(laborshare)
	
	*Overall laborshare
	bysort country year: egen totVA=sum(VA)
	bysort country year: egen totLAB=sum(LAB)
	gen laborshare_ct = totLAB / totVA
	
	*Defining decades
	gen 	decade=1970 if year<1980
	replace decade=1980 if year>=1980&year<1990
	replace decade=1990 if year>=1990&year<2000
	replace decade=2000 if year>=2000
	
	*Define start points for each country-decade
	bysort country decade: egen minyear=min(year) if lnlaborshare!=.
	bysort country: egen maxyear=max(year) if lnlaborshare!=.
		table country decade, c(mean minyear mean maxyear)
	keep if year==minyear|year==maxyear
	
	*Define period lengths for each country-decade
	tsset cross year
	gen nryrs=year-year[_n-1]
	replace nryrs=. if nryrs<0
	
	*Construct annualized laborshare change
	replace decade=2010 if year==maxyear
	tsset cross decade
	gen D_lnlaborshare=(lnlaborshare-L10.lnlaborshare)/nryrs
	gen D_laborshare=(laborshare-L10.laborshare)/nryrs
	
	*Construct mean laborshare
 	gen meanlnlaborshare=(lnlaborshare+L10.lnlaborshare)/2
 	gen meanlaborshare=(laborshare+L10.laborshare)/2
	
	*Construct annualized industry value added share change
	cap bysort country year: egen totVA=sum(VA) if VA!=.
	gen indshare_VA=VA/totVA if VA!=.
	label var indshare_VA "Industry share of VA in total VA, by country-year"
		bysort country year: egen testVA=sum(indshare_VA) if indshare_VA!=.
		sum testVA /*shares sum to 1 by country-year*/
		drop testVA
	tsset cross decade
	gen D_indshare_VA=(indshare_VA-L10.indshare_VA)/nryrs
			
	*Construct mean industry value added share
 	gen meanindshare_VA=(indshare_VA+L10.indshare_VA)/2
	
	*Construct annualized total laborshare change by country-year
	tsset cross decade
	gen D_laborshare_ct= (laborshare_ct-L10.laborshare_ct)/nryrs
	label var laborshare_ct "Laborshare by country-year"
	label var D_laborshare_ct "Total laborshare change by country-year"

	*Construct annualized total log laborshare change by country-year
	bysort country decade: egen lnlaborshare_ct=sum(lnlaborshare*indshare_VA)
	tsset cross decade
	gen D_lnlaborshare_ct=(lnlaborshare_ct-L10.lnlaborshare_ct)/nryrs

	*Merge in country-size weights by decade
	merge m:1 country decade using $path_in\country_weights_bydecade
	drop _
	
	keep country code cross year decade nryrs weight_ls D_lnlaborshare D_laborshare D_indshare_VA D_laborshare_ct D_lnlaborshare_ct mean*

	
*2. Make Table 4: shiftshare for log laborshare, weighted & unweighted across countries
	
	*A. Between effect -- annual change in the national value added share of each industry i weighted by the average log laborshare in industry i (averaging over the current and previous period)
	gen betw_i = D_indshare_VA * meanlnlaborshare
	bysort country year: egen between = sum(betw_i) if betw_i!=.
	label var betw_i  "Industry-level between component for ln laborshare change"
	label var between "Between industry component of ln laborshare change by country-year"
		
	*B. Within effect -- within-industry change in log laborshare weighted by the average VA share of each industry i
	gen with_i = D_lnlaborshare  * meanindshare_VA 
	bysort country year: egen within =sum(with_i) if with_i!=.
	label var with_i  "Industry-level between component for ln laborshare change"
	label var within "Within industry component for ln laborshare change by country-year"
		
	*C. Total country-year change in laborshare
	gen total=D_lnlaborshare_ct
	label var total "Total ln laborshare change by country-year"
	
		*check that within & between sum to total
		gen test=within+between
		gen dif=total-test
		sum dif /*this is zero*/
		drop test dif
		
	collapse (mean) within between total weight_ls, by(country decade)
	foreach var in total within between {
		replace `var'=`var'*100 /*express in 100 x log changes*/
	}

	drop if decade==1970
	replace decade=decade-10
	
	*Unweighted
	bysort decade: egen meantotal=mean(total)
	bysort decade: egen meanwithin=mean(within)
	bysort decade: egen meanbetween=mean(between)
		
	bysort decade: gen meanpwithin=meanwithin/meantotal
	bysort decade: gen meanpbetween=meanbetween/meantotal
	
	table decade, c(mean total mean between mean meanpbetween mean within mean meanpwithin)	 /*Table 4: last three columns*/

	*Weighted
	bysort decade: egen wtmeantotal=sum(weight_ls*total)
	bysort decade: egen wtmeanwithin=sum(weight_ls*within)
	bysort decade: egen wtmeanbetween=sum(weight_ls*between)
	
	bysort decade: gen wtmeanpwithin=wtmeanwithin/wtmeantotal
	bysort decade: gen wtmeanpbetween=wtmeanbetween/wtmeantotal
	
	table decade, c(mean wtmeantotal mean wtmeanbetween mean wtmeanpbetween mean wtmeanwithin mean wtmeanpwithin) /*Table 4: first three columns*/			
		
